"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitmojiStickerLoader = void 0;
const TokenManager_1 = require("./TokenManager");
class BitmojiStickerLoader extends TokenManager_1.TokenManager {
    constructor(bitmojiModule, remoteMediaModule) {
        super();
        this.bitmojiModule = bitmojiModule;
        this.remoteMediaModule = remoteMediaModule;
        this.stickerData = [];
    }
    async loadForUser(snapchatUser, stickerId) {
        const stickerDataEntry = this.findStickerDataEntry(snapchatUser);
        const isPromiseForStickerExists = stickerDataEntry && stickerDataEntry.stickerMap.has(stickerId);
        if (isPromiseForStickerExists) {
            return stickerDataEntry.stickerMap.get(stickerId);
        }
        const promise = this.loadBitmoji(snapchatUser, stickerId);
        if (!stickerDataEntry) {
            this.stickerData.push({
                snapchatUser: snapchatUser,
                stickerMap: new Map([[stickerId, promise]]),
            });
        }
        else {
            stickerDataEntry.stickerMap.set(stickerId, promise);
        }
        return promise;
    }
    loadBitmoji(user, poseId) {
        const options = Bitmoji2DOptions.create();
        options.user = user;
        if (poseId !== '') {
            options.poseId = poseId;
        }
        return new Promise((resolve, reject) => {
            this.bitmojiModule.requestBitmoji2DResource(options, (resource) => {
                this.remoteMediaModule.loadResourceAsImageTexture(resource, texture => resolve(texture), reject);
            });
        });
    }
    findStickerDataEntry(snapchatUser) {
        return this.stickerData.find((stickerDataEntry) => stickerDataEntry.snapchatUser.isSame(snapchatUser));
    }
}
exports.BitmojiStickerLoader = BitmojiStickerLoader;
//# sourceMappingURL=BitmojiStickerLoader.js.map